'UDP_TCP test.bas by Malibu - thebackshed.com
OPTION EXPLICIT
OPTION DEFAULT NONE
option escape
option autorun on

Dim integer True=1, False=0
dim integer StrSize=1024
dim integer  StoreStr(StrSize), FinalStr(StrSize)
dim integer i
dim integer ClearOnRcv=True
dim integer fSize
dim string CrcStr


WEB TCP INTERRUPT WebInterrupt
web udp interrupt UdpInterrupt
? "Local IP Address = " + mm.info(ip address)
? "TCP Server port = " + str$(mm.info(tcp port))
? "UDP Server port = " + str$(mm.info(Udp Port))
?

do
  watchdog 20000
loop

sub WebInterrupt
  local integer ConnNum, ConnData(512)
  ? "Web Hit"
  for ConnNum = 1 to mm.info(Max Connections)
    longstring clear ConnData()
    web tcp read ConnNum, ConnData()
    if llen(ConnData()) > 0 then
      web tcp close ConnNum
    endif
  next ConnNum
end sub

sub UdpInterrupt
  local integer StrLen
  local string RcvStr
  if mm.message$ = "clear" then 'clear command was received
    ClearStoreString
  elseif mm.message$ = "Hello World!" then
    ? "Test string received"
  elseif mm.message$ = "02" then 'Start of transmission
    SetSTX
  elseif mm.message$ = "04" then 'End of transmission
    setEOT
  elseif left$(mm.message$,3) = "CRC" then
    CrcStr = GetCRC(mm.message$)
    fSize = GetfSize(mm.message$)
    ?
    ? "  CRC Received = " + CrcStr
    ? "     File Size = " + str$(fSize)
  else 'There must be something else come in, it's a message to process
    ? ".";
    longstring append StoreStr(), mm.message$
  endif
end sub

sub ClearStoreString()'--- Clear the longstring
  longstring clear StoreStr()
  ? "Longstring cleared..."
end sub

sub SetSTX()'--- If STX is used, place code here
  timer = 0
  ? "STX Received - Transmission Started..."
  ? "Remote address - " + mm.address$
  if ClearOnRcv then longstring clear finalstr()
end sub

sub setEOT()'--- if EOT is used, place code here
  local Crc8Val as string
  ? "EOT Received - Transmission Ended..."
  ?
  ? "All data received in " + str$(timer/1000) + " Seconds"
  if fSize = llen(StoreStr()) then
    ? "...File size pass, checking CRC"
    timer = 0
    Crc8Val = CalculateCRC8(StoreStr())
    if Crc8Val = CrcStr then
      ? "...CRC value pass, time taken = " + str$(timer/1000) + " Seconds"
      longstring copy finalstr(), storestr()
      ? "Sending ACK..."
      web udp send mm.address$,mm.info(Udp Port),"ACK"
    else
      ? "CRC value fail"
      ? "Sending NAK..."
      web udp send mm.address$,mm.info(Udp Port),"NAK"
    endif
  else
    ? "File size fail. " + str$(llen(StoreStr())) + " bytes received"
    ? "Sending NAK..."
    web udp send mm.address$,mm.info(Udp Port),"NAK"
  endif
  ?
  longstring clear storestr()
End sub

Function CalculateCRC8(data() As integer) As string
  local integer crc
  local integer i, j
  timer = 0
  crc = &H00
  For i = 1 To lLen(data())
    crc = (crc Xor (Asc(lgetstr$(data(), i, 1)))) And &HFF
    For j = 1 To 8
      If (crc And &H80) <> 0 Then
        crc = (crc << 1) Xor &H07
      Else
        crc = crc << 1
      End If
    Next j
  Next i
  CalculateCRC8 = right$("00" + hex$(crc),2)
End Function

function GetCRC(data as string) as string
  GetCRC = mid$(data,4,2)
end function

function GetfSize(data as string) as integer
  GetfSize = val(mid$(data,6,10))
end function
